//
//  GHSetData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 5/23/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GHRecordData;

/**
 *  The GHSetData class provides detailed information about a workout set
 *  recorded by the device during a User initiated activity.
 */
@interface GHSetData : NSObject <NSCoding>

/** The number of repetitions in the set. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *repetitions;

/** The duration in seconds for the set. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *duration;

/** The category of the set. Can be null. */
@property (nullable, nonatomic, readonly) NSString *category;

/** The type of the set. Can be null. */
@property (nullable, nonatomic, readonly) NSString *type;

/** Array of records for the set. Refer to GHRecordData for details regarding this data. */
@property (nonnull, nonatomic, readonly) NSArray<GHRecordData *> *recordsArray;


@end
